<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCompanyIdToSubscriptionsTable extends Migration
{
    public function up()
    {
        Schema::table('Subscriptions', function (Blueprint $table) {
            $table->unsignedBigInteger('Company_id')->nullable()->after('Plan_id');
            $table->foreign('Company_id')->references('Company_id')->on('company_profiles')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('Subscriptions', function (Blueprint $table) {
            $table->dropForeign(['Company_id']);
            $table->dropColumn('Company_id');
        });
    }
}
